* International Extension - What Caused the U.S Pandemic-Era Inflation? Bernanke, Blanchard 2023 
* This version : April 16, 2024
* Please contact Dilek Sevinc (dsevinc@piie.com) for further questions. 

* 1-year inflation expectation regression for the 10 economies (excl. Japan  due to confidentiality issues) 
* USA, ECB, BOE, (JPN), FRA, GER, ESP, ITA, NLD, BEL, CAN

global basePath1 ".../Replication Package/(1) Data"
global basePath2 ".../Replication Package/(3) Regression Results"

***************************************************************************************************
* ten year inflation expectation, precovid sample
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


*** USA, ECB, BOE, FRA, ITA, GER, ESP, BEL, NLD, CAN // see also seperate do file for GER

local teams "USA ECB BOE FRA GER ESP ITA NLD BEL CAN"
local startperiod_USA 1989
local startperiod_ECB 1989
local startperiod_BOE 1990
local startperiod_FRA 1989
local startperiod_GER 1996
local startperiod_ITA 1999
local startperiod_ESP 1995
local startperiod_BEL 1996
local startperiod_NLD 1989
local startperiod_CAN 1994

foreach c of local teams{
	
constraint define 4 l1.cf10_`c' + l2.cf10_`c' + l3.cf10_`c' + l4.cf10_`c' + gcpi_`c' + l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' = 1

cnsreg cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), c(4) noconstant 

eststo col4
predict cf10f_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4))
gen cf10_residuals_`c' = cf10_`c'-cf10f_`c'

* Save coefficients in excel format 
putexcel set "(4) cf10_eq_coeff", modify sheet("cf10_`c'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(4) cf10_summary_stats", modify sheet("cf10_`c'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.cf10 through l4.cf10"
putexcel A3 = "gcpi through l4.gcpi"
putexcel A5 = "R2"
putexcel A6 = "number of observations"
putexcel A8 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa4_`c' = _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] 
gen bb4_`c' = _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  

putexcel B2 = aa4_`c'
putexcel B3 = bb4_`c'


* P-value (sum)
test _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] = 0 
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7) 

test _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  = 0
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' 
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7) 
   
test gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c'
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7)    


* R-square and number of observations
corr cf10_`c' cf10f_`c' if period>=tq(1990:1)
gen r2dd_`c' = r(rho)^2
putexcel B5 = r2dd_`c'

gen n_obsdd_`c' = e(N)
putexcel B6 = n_obsdd_`c'


*** unconstrained with homogeneity test 
reg cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), noconstant

test _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] + _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] = 1

matrix b = r(p)'
putexcel B8 = matrix(b), nformat(number_d7)   

	}

	


***************************************************************************************************
* ten year inflation expectation, full sample 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


local teams "USA ECB BOE FRA GER ESP ITA NLD BEL CAN"
local startperiod_USA 1989
local startperiod_ECB 1989
local startperiod_BOE 1990
local startperiod_FRA 1989
local startperiod_GER 1996
local startperiod_ITA 1999
local startperiod_ESP 1995
local startperiod_BEL 1996
local startperiod_NLD 1989
local startperiod_CAN 1994

foreach c of local teams{
	
constraint define 4 l1.cf10_`c' + l2.cf10_`c' + l3.cf10_`c' + l4.cf10_`c' + gcpi_`c' + l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' = 1

cnsreg cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), c(4) noconstant

eststo col4
predict cf10f_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2023:2))
gen cf10_residuals_`c' = cf10_`c'-cf10f_`c'


* Save coefficients in excel format 
putexcel set "(4) cf10_eq_coeff", modify sheet("cf10_`c'")
putexcel D1 = "beta_full"
putexcel D1 = "beta_full"
matrix b = e(b)'
putexcel C2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(4) cf10_summary_stats", modify sheet("cf10_`c'")
putexcel G1 = "sum of coefficients"
putexcel G1 = "sum of coefficients"
putexcel H1 = "p value (sum)"
putexcel I1 = "p value (joint)"
putexcel F2 = "l1.cf10 through l4.cf10"
putexcel F3 = "gcpi through l4.gcpi"
putexcel F5 = "R2"
putexcel F6 = "number of observations"
putexcel F8 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa4_`c' = _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] 
gen bb4_`c' = _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  

putexcel G2 = aa4_`c'
putexcel G3 = bb4_`c'


* P-value (sum)
test _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] = 0 
matrix b = r(p)'
putexcel H2 = matrix(b), nformat(number_d7) 

test _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  = 0
matrix b = r(p)'
putexcel H3 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' 
matrix b = r(p)'
putexcel I2 = matrix(b), nformat(number_d7) 
   
test gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c'
matrix b = r(p)'
putexcel I3 = matrix(b), nformat(number_d7)    


* R-square and number of observations
corr cf10_`c' cf10f_`c' if period>=tq(1990:1)
gen r2dd_`c' = r(rho)^2
putexcel G5 = r2dd_`c'

gen n_obsdd_`c' = e(N)
putexcel G6 = n_obsdd_`c'


*** unconstrained with homogeneity test 
reg cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), noconstant

test _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] + _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] = 1

matrix b = r(p)'
putexcel G8 = matrix(b), nformat(number_d7)   

}

